//
//  $Id: AHKABMainWindowController.m 98 2009-06-12 17:01:44Z fujidana $
//  Copyright (c) 2005-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABMainWindowController.h"
#import "AHKABArrayController.h"
#import "AHKABDoubleEntriesWindowController.h"
#import "AHKUniqueNumberFormatter.h"
#import "AHKPerson.h"
#import "AHKShortTimeDateValueTransformer.h"

static NSString*	AHKABDefaultsDrawerContentSizeKey	= @"AHKABInspectorDrawerContentSize";
static NSString*	AHKABDefaultsPanelAutoSaveNameKey	= @"AHKABInspectorPanel";
static NSString*	AHKDerivingSignsOfZodiacOptionKey	= @"AHKPersonDerivingSignsOfZodiacOption";
//static NSString*	AHKABDefaultsViewOptionsArrayKey	= @"AHKViewOptionsMatrixSelectedTags";
static NSString*	AHKABDefaultsDetachesInspectorKey	= @"AHKABDetachesInspector";
static NSString*	AHKABDefaultsIsInspectorVisibleKey	= @"AHKABIsInspectorVisible";

NSString*	AHKABDefaultsLastSentDateKey				= @"AHKABLastSentDate";
NSString*	AHKABDefaultsLastReceivedDateKey			= @"AHKABLastReceivedDate";
NSString*	AHKABDefaultsVCardFormatIndexKey			= @"AHKABVCardFormatIndex";
NSString*	AHKABDefaultsExportABGroupUIDKey			= @"AHKABExportABGroupUID";
NSString*	AHKABDefaultsIsCardNumberLimitedTo500Key	= @"AHKABIsCardNumberLimitedTo500";

@interface AHKABMainWindowController (Private)

#pragma mark methods to support undo
- (void)startObservingPerson:(AHKPerson *)person;
- (void)stopObservingPerson:(AHKPerson *)person;

@end


#pragma mark -

@implementation AHKABMainWindowController

#pragma mark class methods
+ (void)initialize
{
	// -- set custom value transformer --
	AHKShortTimeDateValueTransformer *shortTimeDateValueTransformer = [[AHKShortTimeDateValueTransformer alloc] init];
	[NSValueTransformer setValueTransformer:shortTimeDateValueTransformer
									forName:@"AHKShortTimeDate"];
	[shortTimeDateValueTransformer release];
	
    NSDictionary *appDefaults = [NSDictionary dictionaryWithObjectsAndKeys:
								 [NSNumber numberWithBool:NO], AHKABDefaultsIsInspectorVisibleKey, 
								 [NSNumber numberWithBool:NO], AHKABDefaultsDetachesInspectorKey,
								 //		NSStringFromSize(NSMakeSize(0, 0)), AHKABDefaultsDrawerContentSizeKey, 
								 [NSNumber numberWithInt:AHKDerivingSignsOfZodiacNo], AHKDerivingSignsOfZodiacOptionKey,
								 //		[self defaultViewOptions], AHKABDefaultsViewOptionsArrayKey,
								 //		[NSNull null], AHKABDefaultsLastSentDateKey, 
								 //		[NSNull null], AHKABDefaultsLastReceivedDateKey, 
								 [NSNumber numberWithInt:AHKKyoponVCardFormat], AHKABDefaultsVCardFormatIndexKey, 
								 //		[NSNull null], AHKABDefaultsExportABGroupUIDKey, 
								 [NSNumber numberWithBool:YES], AHKABDefaultsIsCardNumberLimitedTo500Key,
								 nil];
	
    [[NSUserDefaults standardUserDefaults] registerDefaults:appDefaults];
}


#pragma mark initialization/deallocation methods
- (id)init
{
	self = [self initWithWindowNibName:@"AHKABMainWindow"];
	if (self != nil)
	{
		[self setWindowFrameAutosaveName:@"AHKABMainWindow"];
		
		[[self window] setExcludedFromWindowsMenu:YES];
		[self showWindow:nil];
		
//		[[NSNotificationCenter defaultCenter] addObserver:self
//												 selector:@selector(userDefaultsDidChange:)
//													 name:@"NSUserDefaultsDidChangeNotification"
//												   object:nil];
	}
	return self;
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	// -- load data -- 
	NSUndoManager *undoManager = [[self window] undoManager];
	//	[undoManager disableUndoRegistration];
	
	if ([self loadDefaultDatabase] == NO)
	{
		// do error handling in future...
		[self setPeople:[NSArray array]];
	}
//	[undoManager enableUndoRegistration];
	[undoManager removeAllActions];
	
	// -- binding -- 
	[peopleController bind:@"contentArray" 
				  toObject:self 
			   withKeyPath:@"people" 
				   options:[NSDictionary dictionaryWithObjectsAndKeys:[NSNumber numberWithBool:YES], @"NSRaisesForNotApplicableKeys", [NSNumber numberWithBool:YES], @"NSConditionallySetsEditable", nil]];
	
	// -- set sort descriptor --
	/*
	 NSSortDescriptor *numberDescriptor	= [[[NSSortDescriptor alloc] initWithKey:@"number" ascending:YES] autorelease];
	 NSArray			*sortDescriptors	= [[NSArray alloc] initWithObjects:numberDescriptor, nil];
	 [peopleController setSortDescriptors:sortDescriptors];
	 */
	
	// -- set formatter --
	AHKUniqueNumberFormatter *formatter = [[AHKUniqueNumberFormatter alloc] initWithUniquelyNumberedArrayController:peopleController];
	NSTableColumn *column = [peopleTableView tableColumnWithIdentifier:@"number"];
	[[column dataCell] setFormatter:formatter];
	[numberTextField setFormatter:formatter];
	[formatter release];
	
	// -- set toolbar --
	[self setupToolbar];
	
	// -- enable table view to receive drag and drop
	[peopleController registerTableViewForDraggedTypes];
	
//	// -- load view options and add columns to table --
//	[self setupTableViewWithViewOptions];
	
	// -- load user defaults --
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	
	detachesInspector = [userDefaults boolForKey:AHKABDefaultsDetachesInspectorKey];
	
	NSRect frame   = [inspectorView frame];
	NSSize minSize = NSMakeSize(NSWidth(frame), NSHeight(frame));
	NSSize maxSize = NSMakeSize(NSWidth(frame) * 2, NSHeight(frame));
	
	if (detachesInspector)
	{
		unsigned	style	= NSTitledWindowMask | NSResizableWindowMask | NSClosableWindowMask | NSUtilityWindowMask;
		
		NSRect parentWindowFrame = [[self window] frame];
		NSRect newFrame          = NSMakeRect(NSMaxX(parentWindowFrame), 
											  NSMaxY(parentWindowFrame) - NSHeight([NSWindow frameRectForContentRect:frame styleMask:style]), 
											  NSWidth(frame), 
											  NSHeight(frame));
		
		inspectorPanel = [[NSPanel alloc] initWithContentRect:newFrame
													styleMask:style
													  backing:NSBackingStoreBuffered
														defer:YES];
		
		[inspectorPanel setContentView:inspectorView];
		[inspectorPanel setContentMinSize:minSize];
		[inspectorPanel setContentMaxSize:maxSize];
		[inspectorPanel setTitle:NSLocalizedStringFromTable(@"Info", @"AHKABLocalizable", @"infoPanel.title")];
		[inspectorPanel setFrameAutosaveName:AHKABDefaultsPanelAutoSaveNameKey];
		if ([userDefaults boolForKey:AHKABDefaultsIsInspectorVisibleKey])
		{
			[inspectorPanel orderFront:nil];
		}
	}
	else
	{
		NSSize   size    = minSize;
		NSString *string = [userDefaults stringForKey:AHKABDefaultsDrawerContentSizeKey];
		if (string != nil)
		{
			size = NSSizeFromString(string);
		}
		inspectorDrawer = [[NSDrawer alloc] initWithContentSize:size
												  preferredEdge:NSMaxXEdge];
		[inspectorDrawer setParentWindow:[self window]];
		[inspectorDrawer setContentView:inspectorView];
		[inspectorDrawer setMinContentSize:minSize];
		
		if ([userDefaults boolForKey:AHKABDefaultsIsInspectorVisibleKey])
		{
			[inspectorDrawer open];
		}
	}
	
	[AHKPerson setDerivingSignsOfZodiacOption:[userDefaults integerForKey:AHKDerivingSignsOfZodiacOptionKey]];
	int maxNum = [userDefaults boolForKey:AHKABDefaultsIsCardNumberLimitedTo500Key] ? 500 : 1000; 
	[peopleController setMinValue:0];
	[peopleController setMaxValue:maxNum - 1];
	[AHKPerson setMaximumNumber:maxNum];
	
	/*
	// key-value observing
	NSUserDefaultsController *userDefaultsController = [NSUserDefaultsController sharedUserDefaultsController];
	[self addObserver:userDefaultsController
		   forKeyPath:@"values.AHKABIsCardNumberLimitedTo500"
			  options:(NSKeyValueObservingOptionNew | NSKeyValueObservingOptionOld)
			  context:NULL];
	*/
}

- (void)dealloc
{
	[self setPeople:nil];
	
	[inspectorDrawer setContentView:nil];
	[inspectorDrawer release];
	[inspectorPanel setContentView:nil];
	[inspectorPanel release];
	
	[super dealloc];
}

#pragma mark delegated method by NSWindow
- (void)windowWillClose:(NSNotification *)aNotification
{
	[[self window] makeFirstResponder:nil];
	
	// Save defaults and close the drawer when the window is closed, because the delegate method
	// applicationShouldTerminateAfterLastWindowClosed: does not work when the last window is closed 
	// with its drawer remained open.
	// if applicationShouldTerminateAfterLastWindowClosed: becomes to work with the drawer remained open,
	// the following code will be moved to applicationWillTerminate:
	
	if ([self storeDefaultDatabase] == NO)
	{
		// do error handling in future...
	}
	
	NSUserDefaults	*userDefaults	= [NSUserDefaults standardUserDefaults];
	
	if (detachesInspector)
	{
		[userDefaults setBool:[inspectorPanel isVisible]
					   forKey:AHKABDefaultsIsInspectorVisibleKey];
//		[userDefaults setObject:NSStringFromSize([inspectorPanel contentSize])
//						 forKey:AHKABDefaultsDrawerContentSizeKey];
	}
	else
	{
		[userDefaults setBool:([inspectorDrawer state] == NSDrawerOpenState)
					   forKey:AHKABDefaultsIsInspectorVisibleKey];
		[userDefaults setObject:NSStringFromSize([inspectorDrawer contentSize])
						 forKey:AHKABDefaultsDrawerContentSizeKey];
//		[inspectorDrawer close];
	}
	
//	// -- save view options --
//	[userDefaults setObject:[self selectedViewOptions]
//					 forKey:AHKABDefaultsViewOptionsArrayKey];
}


#pragma mark accessor methods

- (NSMutableArray *)people
{
	return _people;
}

- (void)setPeople:(NSArray *)newPeople
{
	// Store the procedure to undo this action into Undo Stack
	NSUndoManager *undoManager = [[self window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] setPeople:[self people]];
	
//	if (_people != newPeople)
//{
//		[self stopObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndexesInRange:NSMakeRange(0,[_people count])]];
//		
//		[_people release];
//		// copy (retain) every new person and start to observe each key of him. (for undo support)
//		_people = [newPeople mutableCopy];
//		
//		[self startObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndexesInRange:NSMakeRange(0,[_people count])]];
//	}
	if (_people != newPeople)
	{
		AHKPerson		*person;
		NSEnumerator	*enumerator	= [_people objectEnumerator];
		
		// stop observing each key of persons and release them.
		while (person = [enumerator nextObject])
		{
			[self stopObservingPerson:person];
		}
		[_people release];
		// copy (retain) every new person and start to observe each key of him. (for undo support)
		_people = [newPeople mutableCopy];
		enumerator = [_people objectEnumerator];
		while (person = [enumerator nextObject])
		{
			[self startObservingPerson:person];
		}
	}
}

#pragma mark accessor methods for to-many relationships

// required accessor method
- (unsigned int)countOfPeople
{
	return [_people count];
}

// required accessor method
- (AHKPerson *)objectInPeopleAtIndex:(unsigned int)index
{
	return [_people objectAtIndex:index];
}

// optional accessor method
//- (void)getPeople:(id *)people range:(NSRange)range
//{
//	[_people getObjects:people range:range];
//}

// required accessor meethod for mutable 
- (void)insertObject:(AHKPerson *)person inPeopleAtIndex:(unsigned int)index
{
	// Prepare the opposite method into Undo Stack
	NSUndoManager *undoManager = [[self window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] removeObjectFromPeopleAtIndex:index];
	
	// reassign an unused number when the number is already used.
	if ([peopleController containsNumber:[person number] exceptObject:person])
	{
		[person setNumber:[peopleController unusedNumber]];
	}
	
	if([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
	{
		[undoManager setActionName:NSLocalizedStringFromTable(@"Insert Card", @"AHKABLocalizable", @"undo.insertCard")];
	}
	
	[_people insertObject:person atIndex:index];
	
	// start to observe every key of a person and insert him
//	[self startObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndex:index]];

// start to observe every key of a person and insert him
	[self startObservingPerson:person];
}

- (void)removeObjectFromPeopleAtIndex:(unsigned int)index
{
	// Store the procedure to undo this action into Undo Stack
	AHKPerson		*person			= [_people objectAtIndex:index];
	NSUndoManager	*undoManager	= [[self window] undoManager];
	
	[[undoManager prepareWithInvocationTarget:self] insertObject:person inPeopleAtIndex:index];
	
	if ([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
	{
		[undoManager setActionName:NSLocalizedStringFromTable(@"Delete Card", @"AHKABLocalizable", @"undo.deleteCard")];
	}
	
	// stop observation and remove the person from the list
	//	[self stopObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndex:index]];
	
	[self stopObservingPerson:person];
	[_people removeObjectAtIndex:index];
	
	
	/*
	// In Mac OS X 10.3, removing last object of the NSArrayController while the preservesSelection of NSArrayController returns YES, error occurs and undo registration breaks.
	if (floor(NSAppKitVersionNumber) <= NSAppKitVersionNumber10_3)
{
		if ([peopleController preservesSelection])
{
			if ([self countOfPeople] >= index)
{
				[peopleController setSelectionIndexes:[NSIndexSet indexSet]];
			}
		}
	}
	*/
}

// -- this method is not tested. It may not work correctly. --
- (void)replaceObjectInPeopleAtIndex:(unsigned int)index withObject:(AHKPerson *)person
{
	AHKPerson *oldPerson = [_people objectAtIndex:index];
	int       oldNumber  = [oldPerson number];
	
	// Store the procedure to undo this action into Undo Stack
	NSUndoManager *undoManager = [[self window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] replaceObjectAtIndex:index withObject:oldPerson];
	
	// assign the same number as old person
	[person setNumber:oldNumber];
	
	if([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
	{
		[undoManager setActionName:NSLocalizedStringFromTable(@"Replace Card", @"AHKABLocalizable", @"undo.replaceCard")];
	}
	
	/*
	// stop observation and remove the person from the list
	[self stopObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndex:index]];
	
	[_people replaceObjectAtIndex:index withObject:person];
	
	// start to observe every key of a person and insert him
	[self startObservingPeopleAtIndexes:[NSIndexSet indexSetWithIndex:index]];
	*/
	
	// stop observation and remove the person from the list
	[self stopObservingPerson:oldPerson];
	// start to observe every key of a person and insert him
	[self startObservingPerson:person];
	
	[_people replaceObjectAtIndex:index withObject:person];
}


#pragma mark methods to support undo
// to support undoing, enable to track the modification on a person by using key-value observing.
- (void)startObservingPerson:(AHKPerson *)person
{
	[person addObserver:self forKeyPath:@"number" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"groupNumber" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"name" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phoneticName" options:NSKeyValueObservingOptionOld context:nil];
	
	[person addObserver:self forKeyPath:@"phones.firstLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.firstValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.secondLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.secondValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.thirdLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.thirdValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"phones.indexForPreferredValue" options:NSKeyValueObservingOptionOld context:nil];
	//[person addObserver:self forKeyPath:@"phones.preferredLabel" options:NSKeyValueObservingOptionOld context:nil];
	//[person addObserver:self forKeyPath:@"phones.preferredValue" options:NSKeyValueObservingOptionOld context:nil];
	
	[person addObserver:self forKeyPath:@"emails.firstLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.firstValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.secondLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.secondValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.thirdLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.thirdValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"emails.indexForPreferredValue" options:NSKeyValueObservingOptionOld context:nil];
	//[person addObserver:self forKeyPath:@"emails.preferredLabel" options:NSKeyValueObservingOptionOld context:nil];
	//[person addObserver:self forKeyPath:@"emails.preferredValue" options:NSKeyValueObservingOptionOld context:nil];
	
	[person addObserver:self forKeyPath:@"addressLabel" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"addressValue" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"url" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"bloodType" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"zodiac" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"birthday" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"hobby" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"note" options:NSKeyValueObservingOptionOld context:nil];
	[person addObserver:self forKeyPath:@"secured" options:NSKeyValueObservingOptionOld context:nil];
}

// stop key-value observing (used before a person is removed).
- (void)stopObservingPerson:(AHKPerson *)person
{
	[person removeObserver:self forKeyPath:@"number"];
	[person removeObserver:self forKeyPath:@"groupNumber"];
	[person removeObserver:self forKeyPath:@"name"];
	[person removeObserver:self forKeyPath:@"phoneticName"];
	
	[person removeObserver:self forKeyPath:@"phones.firstLabel"];
	[person removeObserver:self forKeyPath:@"phones.firstValue"];
	[person removeObserver:self forKeyPath:@"phones.secondLabel"];
	[person removeObserver:self forKeyPath:@"phones.secondValue"];
	[person removeObserver:self forKeyPath:@"phones.thirdLabel"];
	[person removeObserver:self forKeyPath:@"phones.thirdValue"];
	[person removeObserver:self forKeyPath:@"phones.indexForPreferredValue"];
	//[person removeObserver:self forKeyPath:@"phones.preferredLabel"];
	//[person removeObserver:self forKeyPath:@"phones.preferredValue"];
	
	[person removeObserver:self forKeyPath:@"emails.firstLabel"];
	[person removeObserver:self forKeyPath:@"emails.firstValue"];
	[person removeObserver:self forKeyPath:@"emails.secondLabel"];
	[person removeObserver:self forKeyPath:@"emails.secondValue"];
	[person removeObserver:self forKeyPath:@"emails.thirdLabel"];
	[person removeObserver:self forKeyPath:@"emails.thirdValue"];
	[person removeObserver:self forKeyPath:@"emails.indexForPreferredValue"];
	//[person removeObserver:self forKeyPath:@"emails.preferredLabel"];
	//[person removeObserver:self forKeyPath:@"emails.preferredValue"];
	
	[person removeObserver:self forKeyPath:@"addressLabel"];
	[person removeObserver:self forKeyPath:@"addressValue"];
	[person removeObserver:self forKeyPath:@"url"];
	[person removeObserver:self forKeyPath:@"bloodType"];
	[person removeObserver:self forKeyPath:@"zodiac"];
	[person removeObserver:self forKeyPath:@"birthday"];
	[person removeObserver:self forKeyPath:@"hobby"];
	[person removeObserver:self forKeyPath:@"note"];
	[person removeObserver:self forKeyPath:@"secured"];
}


// to support undoing, enable to track the modification on people at indexes by using key-value observing.
//- (void)startObservingPeopleAtIndexes:(NSIndexSet *)indexes
//{
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"number" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"groupNumber" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"name" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phoneticName" options:NSKeyValueObservingOptionOld context:nil];
//	
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.firstLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.firstValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.secondLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.secondValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.thirdLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.thirdValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.indexForPreferredValue" options:NSKeyValueObservingOptionOld context:nil];
////	//[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.preferredLabel" options:NSKeyValueObservingOptionOld context:nil];
////	//[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"phones.preferredValue" options:NSKeyValueObservingOptionOld context:nil];
////	
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.firstLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.firstValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.secondLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.secondValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.thirdLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.thirdValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.indexForPreferredValue" options:NSKeyValueObservingOptionOld context:nil];
////	//[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.preferredLabel" options:NSKeyValueObservingOptionOld context:nil];
////	//[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"emails.preferredValue" options:NSKeyValueObservingOptionOld context:nil];
////	
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"addressLabel" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"addressValue" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"url" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"bloodType" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"zodiac" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"birthday" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"hobby" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"note" options:NSKeyValueObservingOptionOld context:nil];
//	[_people addObserver:self toObjectsAtIndexes:indexes forKeyPath:@"secured" options:NSKeyValueObservingOptionOld context:nil];
//}
//
//// stop key-value observing (used before people at indexes is removed).
//- (void)stopObservingPeopleAtIndexes:(NSIndexSet *)indexes
//{
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"number"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"groupNumber"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"name"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phoneticName"];
//	
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.firstLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.firstValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.secondLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.secondValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.thirdLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.thirdValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.indexForPreferredValue"];
////	//[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.preferredLabel"];
////	//[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"phones.preferredValue"];
////
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.firstLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.firstValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.secondLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.secondValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.thirdLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.thirdValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.indexForPreferredValue"];
////	//[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.preferredLabel"];
////	//[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"emails.preferredValue"];
////
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"addressLabel"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"addressValue"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"url"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"bloodType"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"zodiac"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"birthday"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"hobby"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"note"];
//	[_people removeObserver:self fromObjectsAtIndexes:indexes forKeyPath:@"secured"];
//}

// -- auxiliary method to excute Undo action for editing --
- (void)changeKeyPath:(NSString *)keyPath ofObject:(id)obj toValue:(id)newValue
{
	[peopleController setSelectedObjects:[NSArray arrayWithObject:obj]];
	if (newValue == nil || [newValue isEqual:[NSNull null]])
	{
		[obj setValue:nil forKeyPath:keyPath];
	}
	else
	{
		[obj setValue:newValue forKeyPath:keyPath];
	}
}

// -- override the method of NSObject which responds to @selector(addObserver:forKeyPath:options:context:) -- 
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	// -- get an old value --
	id oldValue = [change objectForKey:NSKeyValueChangeOldKey];
	
	// -- register action before undo --
	NSUndoManager *undoManager = [[self window] undoManager];
	[[undoManager prepareWithInvocationTarget:self] changeKeyPath:keyPath ofObject:object toValue:oldValue];
	if ([undoManager isUndoing] == NO && [undoManager isRedoing] == NO)
	{
		[undoManager setActionName:NSLocalizedStringFromTable(@"Edit", @"AHKABLocalizable", @"undo.edit")];
	}
}

//- (void)observeDidEnd:(NSAlert *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
//{
//	NSArray  *paramsArray = (NSArray *)contextInfo;
//	id        object	  = [paramsArray objectAtIndex:0];
//	NSString *keyPath     = [paramsArray objectAtIndex:1];
//	id        oldValue	  = [paramsArray objectAtIndex:2];
//	
//	// -- set the value for the key into an old value.
//	[object removeObserver:self forKeyPath:keyPath];
//	[object setValue:oldValue forKeyPath:keyPath];
//	[object addObserver:self forKeyPath:keyPath options:NSKeyValueObservingOptionOld context:nil];
//	
//	// -- select an undone object.
//	unsigned row = [[peopleController arrangedObjects] indexOfObject:object];
//	[peopleController setSelectionIndexes:[NSIndexSet indexSetWithIndex:row]];
//	
//	[paramsArray release];
//}

#pragma mark IBActions and their delegation methods

- (IBAction)toggleInspector:(id)sender
{
	if (detachesInspector)
	{
		if ([inspectorPanel isVisible])
		{
			[inspectorPanel orderOut:sender];
		}
		else
		{
			[inspectorPanel makeKeyAndOrderFront:sender];
		}
	}
	else
	{
		[inspectorDrawer toggle:sender];
	}
}

- (IBAction)selectNext:(id)sender
{
	[peopleController selectNext:sender];
}

- (IBAction)selectPrevious:(id)sender
{
	[peopleController selectPrevious:sender];
}

- (IBAction)add:(id)sender
{
	[peopleController add:sender];
}

- (IBAction)insert:(id)sender
{
	[peopleController insert:sender];
}

- (IBAction)delete:(id)sender
{
	[peopleController remove:sender];
}

- (IBAction)find:(id)sender
{
	[[self window] makeFirstResponder:searchField];
}

//- (IBAction)findSelection:(id)sender
//{
//}

- (IBAction)renumberSelection:(id)sender
{
	NSUndoManager *undoManager    = [[self window] undoManager];
	NSArray       *selectedPeople = [peopleController selectedObjects];
	
	if ([selectedPeople count] > 1)
	{
		int       firstNumber = [[selectedPeople objectAtIndex:0] number];
		AHKPerson *person;
		NSRange   range;
		NSArray   *subarray;
		int       i, newNumber;
		
		for (i = 0; i < [selectedPeople count]; i++)
		{
			person    = [selectedPeople objectAtIndex:i];
			range     = NSMakeRange(i, ([selectedPeople count] - i));
			subarray  = [selectedPeople subarrayWithRange:range];
			newNumber = [peopleController unusedNumberAboveNumber:(firstNumber + i)
													exceptObjects:subarray];
			[person setNumber:newNumber];
		}
		[undoManager setActionName:NSLocalizedStringFromTable(@"Renumber", @"AHKABLocalizable", @"undo.renumberSelection")];
	}
}

- (IBAction)listDoubleEntries:(id)sender
{
	AHKABDoubleEntriesWindowController *doubleEntriesWindowController = [AHKABDoubleEntriesWindowController sharedWindowControllerWithMainWindowController:self];
	[doubleEntriesWindowController checkDoubleEntries:self];
	[doubleEntriesWindowController showWindow:self];
}

- (IBAction)deselectSort:(id)sender
{
	[peopleController setSortDescriptors:[NSArray array]];
	[peopleController rearrangeObjects];
}

- (IBAction)sortPeopleInNumberingOrder:(id)sender
{
	NSUndoManager    *undoManager      = [[self window] undoManager];
	
	NSSortDescriptor *numberDescriptor = [[[NSSortDescriptor alloc] initWithKey:@"number" ascending:YES] autorelease];
	NSArray          *sortDescriptors  = [NSArray arrayWithObject:numberDescriptor];
	NSArray          *newPeople        = [[self people] sortedArrayUsingDescriptors:sortDescriptors];
	
	[self setPeople:newPeople];
	[undoManager setActionName:NSLocalizedStringFromTable(@"Sort in Numbering Order", @"AHKABLocalizable", @"undo.sortPersonArrayInNumberingOrder")];
}

#pragma mark other methods
- (void)searchForString:(NSString *)string options:(int)option
{
	[peopleController setSearchFilterTag:option];
	[peopleController setSearchString:string];
	
	[[[self window] undoManager] setActionName:NSLocalizedStringFromTable(@"Search", @"AHKABLocalizable", @"undo.searchWordWithOption")];
	//[peopleController search:self];
	//[searchField performClick:self];
}

@end